/*
 * Decompiled with CFR 0.152.
 */
package com.roguewave.chart.standard.v2_1.parts;

import com.roguewave.chart.core.v2_1.graphics.Point3D;
import com.roguewave.chart.core.v2_1.graphics.Polygon3D;
import com.roguewave.chart.core.v2_1.graphics.Transform3D;
import java.awt.Color;

public class Bar {
    public static final int FRONT = 1;
    public static final int BACK = 2;
    public static final int RIGHT = 4;
    public static final int LEFT = 8;
    public static final int BOTTOM = 16;
    public static final int TOP = 32;
    private Polygon3D[] faces_;
    private Polygon3D[] frontFace_;

    public Bar(Point3D origin, double width, double depth, double height, Color color) {
        Bar temp = new Bar(origin, width, depth, height, new Transform3D(), color);
        this.faces_ = temp.faces_;
        this.frontFace_ = temp.frontFace_;
    }

    public Bar(double width, double depth, double height, Transform3D transform, Color color) {
        Bar temp = new Bar(new Point3D(0.0, 0.0, 0.0), width, depth, height, new Transform3D(), color);
        this.faces_ = temp.faces_;
        this.frontFace_ = temp.frontFace_;
    }

    public Bar(Point3D origin, double width, double depth, double height, Transform3D transform, Color color) {
        this(origin, width, depth, height, transform, color, 22);
    }

    public Bar(Point3D origin, double width, double depth, double height, Transform3D transform, Color color, int shading) {
        Point3D p1 = transform.transform(new Point3D(origin.X() - width / (double)2, origin.Y(), origin.Z() - depth / (double)2));
        Point3D p2 = transform.transform(new Point3D(origin.X() - width / (double)2, origin.Y() + height, origin.Z() - depth / (double)2));
        Point3D p3 = transform.transform(new Point3D(origin.X() + width / (double)2, origin.Y() + height, origin.Z() - depth / (double)2));
        Point3D p4 = transform.transform(new Point3D(origin.X() + width / (double)2, origin.Y(), origin.Z() - depth / (double)2));
        Point3D p8 = transform.transform(new Point3D(origin.X() - width / (double)2, origin.Y(), origin.Z() + depth / (double)2));
        Point3D p7 = transform.transform(new Point3D(origin.X() - width / (double)2, origin.Y() + height, origin.Z() + depth / (double)2));
        Point3D p6 = transform.transform(new Point3D(origin.X() + width / (double)2, origin.Y() + height, origin.Z() + depth / (double)2));
        Point3D p5 = transform.transform(new Point3D(origin.X() + width / (double)2, origin.Y(), origin.Z() + depth / (double)2));
        this.faces_ = new Polygon3D[6];
        this.frontFace_ = new Polygon3D[1];
        Color darker = color.darker();
        this.faces_[0] = new Polygon3D(4, (shading & 1) == 0 ? color : darker);
        this.faces_[0].addPoint(p1);
        this.faces_[0].addPoint(p2);
        this.faces_[0].addPoint(p3);
        this.faces_[0].addPoint(p4);
        this.frontFace_[0] = this.faces_[0];
        this.faces_[1] = new Polygon3D(4, (shading & 2) == 0 ? color : darker);
        this.faces_[1].addPoint(p5);
        this.faces_[1].addPoint(p6);
        this.faces_[1].addPoint(p7);
        this.faces_[1].addPoint(p8);
        this.faces_[2] = new Polygon3D(4, (shading & 4) == 0 ? color : darker);
        this.faces_[2].addPoint(p4);
        this.faces_[2].addPoint(p3);
        this.faces_[2].addPoint(p6);
        this.faces_[2].addPoint(p5);
        this.faces_[3] = new Polygon3D(4, (shading & 8) == 0 ? color : darker);
        this.faces_[3].addPoint(p8);
        this.faces_[3].addPoint(p7);
        this.faces_[3].addPoint(p2);
        this.faces_[3].addPoint(p1);
        this.faces_[4] = new Polygon3D(4, (shading & 0x10) == 0 ? color : darker);
        this.faces_[4].addPoint(p8);
        this.faces_[4].addPoint(p1);
        this.faces_[4].addPoint(p4);
        this.faces_[4].addPoint(p5);
        this.faces_[5] = new Polygon3D(4, (shading & 0x20) == 0 ? color : darker);
        this.faces_[5].addPoint(p2);
        this.faces_[5].addPoint(p7);
        this.faces_[5].addPoint(p6);
        this.faces_[5].addPoint(p3);
    }

    public Polygon3D[] polygons() {
        return this.faces_;
    }

    public Polygon3D[] front() {
        return this.frontFace_;
    }
}

